%
% [Andrea Mannini: a.mannini@sssup.it; Created: Apr 13 2012]


close all
clear variables


add_toolboxes_to_path;

%% Experiments selection: SELECT THE EXPERIMENT TO RUN BY UNCOMMENTING

%-------------------------------
placementsite = 'Wrist';
% placementsite = 'Ankle';
%-------------------------------

outputenabled = 1;


%-------------------------------
% % Exp1:
% young = 1;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =0;
% use_generalmodel = 0;
% applyFS = 0;
% use_Dmaxmin  = 0;
% use_LowP = 0;
% use_HiP = 0;
% use_Hz2P =0;
% use_onset1 = 0;
% use_onset2= 0;
% use_onset3 = 0;
% use_onset4= 0;
% bestc = 100;
% bestg = 0.1;
% windowlength = '12800';

%------------------------------------------
% % Exp2 (A):
% young = 0;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =0;
% use_generalmodel = 0;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% windowlength = '12800';

%------------------------------------------
% % Exp2 (Y):
young = 1;
kids_and_adults = 0;
remove_new_activities = 0;
train_generalmodel =0;
use_generalmodel = 0;
applyFS = 1;
use_Dmaxmin  = 1;
use_LowP = 1;
use_HiP = 1;
use_Hz2P = 1;
use_onset1 = 1;
use_onset2= 1;
use_onset3 = 1;
use_onset4= 1;
if strcmp(placementsite,'Ankle')
    bestc = 16;
    bestg = 0.25;
else
    bestc = 128;
    bestg = 0.0625;
end
windowlength = '12800';

%------------------------------------------
% % Exp3.1.part1 - Training on A  (original feature set)
% young = 0;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =1;
% use_generalmodel = 0;
% applyFS = 0;
% use_Dmaxmin  = 0;
% use_LowP = 0;
% use_HiP = 0;
% use_Hz2P =0;
% use_onset1 = 0;
% use_onset2= 0;
% use_onset3 = 0;
% use_onset4= 0;
% bestc = 100;
% bestg = 0.1;
% saveto = 'model1'
% windowlength = '12800';

% % Exp3.1.part2 - Testing on Y (original feature set)
% young = 1;
% kids_and_adults = 0;
% remove_new_activities = 1;
% train_generalmodel =0;
% use_generalmodel = 1;
% applyFS = 0;
% use_Dmaxmin  = 0;
% use_LowP = 0;
% use_HiP = 0;
% use_Hz2P =0;
% use_onset1 = 0;
% use_onset2= 0;
% use_onset3 = 0;
% use_onset4= 0;
% bestc = 100;
% bestg = 0.1;
% loadfrom = 'model1'
% windowlength = '12800';

%------------------------------------------
% % Exp3.2.part1 - Training on A (new feature set)
% young = 0;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =1;
% use_generalmodel = 0;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% saveto = 'model2'
% windowlength = '12800';

% % Exp3.2.part2 - Testing on Y (new feature set)
% young = 1;
% kids_and_adults = 0;
% remove_new_activities = 1;
% train_generalmodel =0;
% use_generalmodel = 1;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% loadfrom = 'model2'
% windowlength = '12800';

%------------------------------------------
% % Exp3.3.part1 - Training on Y (original feature set)
% young = 1;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =1;
% use_generalmodel = 0;
% applyFS = 0;
% use_Dmaxmin  = 0;
% use_LowP = 0;
% use_HiP = 0;
% use_Hz2P =0;
% use_onset1 = 0;
% use_onset2= 0;
% use_onset3 = 0;
% use_onset4= 0;
% bestc = 100;
% bestg = 0.1;
% saveto = 'model3'
% windowlength = '12800';

% % Exp3.3.part2 - Testing on A (original feature set)
% young = 0;
% kids_and_adults = 0;
% remove_new_activities = 1;
% train_generalmodel =0;
% use_generalmodel = 1;
% applyFS = 0;
% use_Dmaxmin  = 0;
% use_LowP = 0;
% use_HiP = 0;
% use_Hz2P =0;
% use_onset1 = 0;
% use_onset2= 0;
% use_onset3 = 0;
% use_onset4= 0;
% bestc = 100;
% bestg = 0.1;
% loadfrom = 'model3'
% windowlength = '12800';

%------------------------------------------
% % Exp3.4.part1 - Training on Y (new feature set)
% young = 1;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =1;
% use_generalmodel = 0;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% saveto = 'model4'
% windowlength = '12800';

% % Exp3.4.part2 - Testing on A (new feature set)
% young = 0;
% kids_and_adults = 0;
% remove_new_activities = 1;
% train_generalmodel =0;
% use_generalmodel = 1;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% loadfrom = 'model4'
% windowlength = '12800';
%------------------------------------------

% % Exp4:
% young = 1;
% kids_and_adults = 1;
% remove_new_activities = 0;
% train_generalmodel =0;
% use_generalmodel = 0;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% windowlength = '12800';
%------------------------------------------

% % Exp 5:
% young = 1;
% kids_and_adults = 0;
% remove_new_activities = 0;
% train_generalmodel =0;
% use_generalmodel = 0;
% applyFS = 1;
% use_Dmaxmin  = 1;
% use_LowP = 1;
% use_HiP = 1;
% use_Hz2P = 1;
% use_onset1 = 1;
% use_onset2= 1;
% use_onset3 = 1;
% use_onset4= 1;
% if strcmp(placementsite,'Ankle')
%     bestc = 16;
%     bestg = 0.25;
% else
%     bestc = 128;
%     bestg = 0.0625;
% end
% % windowlength = '4000';
% windowlength = '8000';
% % windowlength = '3200';
% % windowlength = '6400';

%-------------------------------


%% Load feature set
disp('Loading data...')

exportdata = 0;
correction = 'ON';
samplingrate = '90';
checkerrors = 0;
if young
    nomefile = ['StanfordDataset2010_youth_' placementsite '_win' windowlength '_corrected_classes1to3_apr2013_' samplingrate 'Hz_filt_o4f20_recalib_dec2013D']; %MSSE2016 % questo dovrebbe essere quello giusto per 12.8
    %     nomefile = ['StanfordDataset2010_youth_' placementsite '_win' windowlength '_corrected_classes1to3_apr2013_' samplingrate 'Hz_filt_o4f20_recalib_ubicomp'];
    %     nomefile = ['StanfordDataset2010_youth_' placementsite '_win' windowlength '_corrected_classes1to3_apr2013_' samplingrate 'Hz_filt_o4f20_recalib_dec2013D_reload'];
    usefeatureset = 3;
else
    nomefile = ['StanfordDataset2010_adult_' placementsite '_win' windowlength '_corrected_classes1to3_apr2013_' samplingrate 'Hz_filt_o4f20_recalib_dec2013D'];  %MSSE2016 % questo dovrebbe essere quello giusto per 12.8
    usefeatureset = 3;
    
end
load (nomefile); toremove = [];



if kids_and_adults
    Data_tmp = Data;
    Info_tmp = Info;
    Labels_tmp = Labels;
    
    if young
        nomefile = ['StanfordDataset2010_adult_' placementsite '_win' windowlength '_corrected_classes1to3_apr2013_' samplingrate 'Hz_filt_o4f20_recalib_dec2013D'];
        usefeatureset = 3;
        NY = length(Info_tmp);
        load (nomefile); toremove = [];
        Data = [Data_tmp Data];
        Info = [Info_tmp Info];
        Labels = [Labels_tmp Labels];
        NA = length(Info)-NY;
        
    else
        nomefile = ['StanfordDataset2010_youth_' placementsite '_win' windowlength '_corrected_classes1to3_apr2013_' samplingrate 'Hz_filt_o4f20_recalib_dec2013D'];
        usefeatureset = 3;
        NA = length(Info_tmp);
        load (nomefile); toremove = [];
        Data = [Data Data_tmp];
        Info = [Info Info_tmp];
        Labels = [Labels Labels_tmp];
        NY = length(Info)-NA;
    end
    
    
end

crop_transitions = 1
wincrop = 0   %12.8s win



%% ALGORITHM settings:
applyPCA = 0;

useMagnitude = 1; % use SMV also in the evaluation of "simple" features
clasf = [1]%0:2%[1:10];
nfold = 10;
Np = length(Data)
use_rawdata = 0;

runFS = 0; params.crit_var = 0;
% set nuovo applicando fs con banda 1.5
use_tf = 1;
use_wvlt1 = 0;
use_wvlt2 = 0;
use_mean = 1;
use_std  = 1;
use_max  = 1;
use_min  = 1;
use_var  = 0;

aboutrun = 1; % 1 = add to ambulation; 0 = remove run
if aboutrun
    walk_labels = [1 22 23 25:36 45 50:52 65:73 77:83];
else
    walk_labels = [1 22 23 25:36 45 50:52 65:73 79:81];
end
nonwalk_labels = [2:21 24 38 40:44 46:49 53:64 74:76 84];


%% 1: Dataset preparation
% Group data
Lab1w = [];
Lab2w = [];
Lab3w = [];
Lab4w = [];
Lab5w = [];
Data_m = [];
% Data_mi = [];
subj_label = [];
P1 = []; F1 = [];T1 = [];
Px = [ ];
% fs = Info(1).fs;
removed_subject = [];

for p =1:Np
    
    if ismember(p,toremove)
        removed_subject = [removed_subject; p]
        continue
    end
    if ~(sum(Labels(p).Lab3w == 1) )
        removed_subject = [removed_subject; p]
        continue
    end
    
    %%%
    new_acts = [40:42 45 49 54:55 57 58 63 64 75 76 84];
    ind_st = find(ismember(Labels(p).Lab2w,new_acts));
    if length(ind_st) == length(Labels(p).Lab2w)
        disp('pausa')
    end
    %%%
    
    Lab1w = [Lab1w; Labels(p).Lab1w];
    Lab2w = [Lab2w; Labels(p).Lab2w];
    Lab3w = [Lab3w; Labels(p).Lab3w];
    Lab4w = [Lab4w; Labels(p).Lab4w];
   
    Lab5w = [Lab5w; Labels(p).Lab5w(~isnan(Labels(p).Lab5w))];
    
    
    if use_rawdata
        Data_m = [Data_m; Data(p).raw_m];
    end
    
    removed_timefreq = []; removed_easy = [];
    switch usefeatureset
        case 1
            E = size(Data(p).Pm, 1);
            if ~use_wvlt2
                removed_timefreq = [removed_timefreq E];
            end
            if ~use_wvlt1
                removed_timefreq = [removed_timefreq E-1];
            end
            if ~use_tf
                removed_timefreq = [removed_timefreq E-2:-1:E-10];
            end
            if ~use_mean
                removed_easy = [removed_easy  1];
            end
            if ~use_std
                removed_easy = [removed_easy  2];
            end
            if ~use_var
                removed_easy = [removed_easy  3];
            end
            if ~use_max
                removed_easy = [removed_easy  4];
            end
            if ~use_min
                removed_easy = [removed_easy  5];
            end
            if ~use_Dmaxmin
                removed_easy = [removed_easy  6 ];
            end
            Data(p).Pm([removed_easy removed_timefreq],:) = [];
            P1 = [P1  Data(p).Pm];
            
            
        case 2
            E = size(Data(p).Pm2, 1);
            if ~use_Hz2P
                removed_timefreq = [removed_timefreq E];
            end
            if ~use_HiP
                removed_timefreq = [removed_timefreq E-1];
            end
            if ~use_LowP
                removed_timefreq = [removed_timefreq E-2];
            end
            if ~use_wvlt2
                removed_timefreq = [removed_timefreq E-3];
            end
            if ~use_wvlt1
                removed_timefreq = [removed_timefreq E-4];
            end
            if ~use_tf
                removed_timefreq = [removed_timefreq E-5:-1:E-13];
            end
            if ~use_mean
                removed_easy = [removed_easy  1];
            end
            if ~use_std
                removed_easy = [removed_easy  2];
            end
            if ~use_var
                removed_easy = [removed_easy  3];
            end
            if ~use_max
                removed_easy = [removed_easy  4];
            end
            if ~use_min
                removed_easy = [removed_easy  5];
            end
            if ~use_Dmaxmin
                removed_easy = [removed_easy  6 ];
            end
            Data(p).Pm2([removed_easy removed_timefreq],:) = [];
            P1 = [P1  Data(p).Pm2];
            
        case 3
            E = size(Data(p).Pm3, 1);
            if ~use_onset4
                removed_timefreq = [removed_timefreq E];
            end
            if ~use_onset3
                removed_timefreq = [removed_timefreq E-1];
            end
            if ~use_onset2
                removed_timefreq = [removed_timefreq E-2];
            end
            if ~use_onset1
                removed_timefreq = [removed_timefreq E-3];
            end
            if ~use_Hz2P
                removed_timefreq = [removed_timefreq E-4];
            end
            if ~use_HiP
                removed_timefreq = [removed_timefreq E-5];
            end
            if ~use_LowP
                removed_timefreq = [removed_timefreq E-6];
            end
            if ~use_wvlt2
                removed_timefreq = [removed_timefreq E-7];
            end
            if ~use_wvlt1
                removed_timefreq = [removed_timefreq E-8];
            end
            if ~use_tf
                removed_timefreq = [removed_timefreq E-9:-1:E-17];
            end
            if ~use_mean
                removed_easy = [removed_easy  1];
            end
            if ~use_std
                removed_easy = [removed_easy  2];
            end
            if ~use_var
                removed_easy = [removed_easy  3];
            end
            if ~use_max
                removed_easy = [removed_easy  4];
            end
            if ~use_min
                removed_easy = [removed_easy  5];
            end
            if ~use_Dmaxmin
                removed_easy = [removed_easy  6 ];
            end
            Data(p).Pm3([removed_easy removed_timefreq],:) = [];
            P1 = [P1  Data(p).Pm3];
            
            Px = [Px  Data(p).PX];
    end
    subj_wins(p) = length(Labels(p).Lab3w);
    subj_label = [subj_label; p*ones(length(Labels(p).Lab3w),1)];
    
end
Np = Np -length(removed_subject);
clear Data
% clear Labels
disp('done')

%% remove activities
% standing still carrying load correction
ind_st = find(  (ismember(Lab2w,[11 12 13 14])) );
ind_st2 = find(  ismember(Lab1w,[18]) & ismember(Lab2w,[1]) );
ind_st = unique([ind_st;ind_st2]);

Lab1w(ind_st) = 25;
Lab2w(ind_st) = 39;

% move wii data from other to sedentary
indwii = find(  (ismember(Lab2w,[75 76])) );

Lab5w(indwii) = 5;

%% problem choose

inst = P1';% (abs(P1(:,:)'));
clear P1
labels = Lab5w;

inst(labels <= 0,:) = [];  % remove unknowns + standing oir sitting on a bike
subj_label(labels <= 0,:) = [];
Lab1w(labels <= 0,:) = [];
Lab2w(labels <= 0,:) = [];
Lab3w(labels <= 0,:) = [];
Lab4w(labels <= 0,:) = [];
Lab5w(labels <= 0,:) = [];
if use_rawdata
    Data_m(labels <= 0,:) = [];
end
labels(labels <= 0,:) = [];

if ~aboutrun
    % delete run data
    inst(labels == 1,:) = [];
    subj_label(labels == 1,:) = [];
    Lab1w(labels == 1,:) = [];
    Lab2w(labels == 1,:) = [];
    Lab3w(labels == 1,:) = [];
    Lab4w(labels == 1,:) = [];
    Lab5w(labels == 1,:) = [];
    labels(labels == 1,:) = [];
    if use_rawdata
        Data_m(labels == 1,:) = [];
    end
else
    % or use it as ambulation examples (default)
    Lab5w(labels == 1,:) = 2;
    labels = Lab5w;
end


% -----------------------------
    labels = labels-1;

% -----------------------------

%% crop windows across transitions
if crop_transitions
    transit = find((diff([0; Lab1w]) ~=0 | diff([0; Lab2w]) ~=0));
    %     transit = find(diff([0; Lab1w]) ~=0);
    L = length(transit);
    for u = 1:L
        tmp(u,:) = [transit(u)-wincrop-1:transit(u)+wincrop];
    end
    to_remove = unique(tmp);
    to_remove = to_remove(to_remove>0);
    to_remove = to_remove(to_remove<=length(labels));
    inst(to_remove,:) = [];
    subj_label(to_remove,:) = [];
    labels(to_remove,:) = [];
    
    Lab1w(to_remove,:) = [];
    Lab2w(to_remove,:) = [];
    Lab3w(to_remove,:) = [];
    Lab4w(to_remove,:) = [];
    Lab5w(to_remove,:) = [];
    if use_rawdata
        Data_m(to_remove,:) = [];
    end
end


%% remove activities not existing in previous dataset (only in Exp 3)
if remove_new_activities
    if young
        new_acts = [40:42 45 49 54:55 57 58 63 64 75 76 82 83 84];
    else
        new_acts = [15 16];
    end
    ind_st = find(ismember(Lab2w,new_acts));
    
    Lab1w(ind_st) = [];
    Lab2w(ind_st) = [];
    Lab3w(ind_st) = [];
    Lab4w(ind_st) = [];
    Lab5w(ind_st) = [];
    inst(ind_st,:)  = [];
    labels(ind_st,:) = [];
    subj_label(ind_st,:) = [];
end


%% remove unlabelled
annotated_interval = ~(  ((Lab1w==25)&(Lab2w==38)) |(Lab2w==39));
Lab1w = Lab1w(annotated_interval);
Lab2w = Lab2w(annotated_interval);
Lab3w = Lab3w(annotated_interval);
Lab4w = Lab4w(annotated_interval);
Lab5w = Lab5w(annotated_interval);
inst    = inst(annotated_interval,:);
labels = labels(annotated_interval,:);
subj_label = subj_label(annotated_interval);
if use_rawdata
    Data_m = Data_m(annotated_interval,:);
end



%% 2: Feature selection
%
if (applyFS)
    disp('Feature Selection')
    if (runFS)
        
        params.sc_low = -1;
        params.sc_up = 1;
        
        params.bestc = 100;
        params.bestg = 0.1;
        
        params.Pb = 0;
        params.kernel = 2;
        params.maxlabelnum = 5;
        params.termination = 0.0000001;
        
        keepin = [1];% [15 1 2 5];
        if ~isempty(keepin)
            disp(['Features included by default at first run'])
        end
        
        %         matlabpool open
        X_tr = inst;
        y_tr = labels;
        y_sogg_tr = subj_label;
        pippo = 0;
        % features selection:
        fun = @(X_tr,y_tr,y_sogg_tr,X_val,y_val,y_sogg_val) criterioFS_SVMc_Fscore_PAR(params,X_tr,y_tr,y_sogg_tr,X_val,y_val,y_sogg_val);
        opt = statset('display', 'iter');
        [Fs, history] = sequentialfs(fun,X_tr,y_tr,y_sogg_tr,'cv','resubstitution','direction','forward','options',opt,'keepin',keepin)
        
        clear X_tr X_val
        savefile = [placementsite '_fs_fwd_svm_wii_loso_NOWVLT_D.mat'];
        save(savefile, 'Fs', 'history');
        %         matlabpool close
    else
        load([placementsite '_featsel_output.mat'])
    end
    inst = inst(:,Fs);
end


%% 3: Parameters optimization
%
% [bestc, bestg, cost] = ottimiz_param_SVM_LOSO_PAR(inst, labels,2:1:11,-5:1:-1,subj_label,1,2);
% save ottimizzazioneSVM_loso_tuttelefeatures_ankle_SFS_C2_1_11_gm5_1_m1.mat bestc bestg cost


%% features analysis
if usefeatureset>1
    % spectrumtest
    Sp(:,1) = mean(Px(:,labels==1),2);
    Sp(:,2) = mean(Px(:,labels==2),2);
    Sp(:,3) = mean(Px(:,labels==3),2);
    Sp(:,4) = mean(Px(:,labels==4),2);
    
    f_psd = 0.3:0.1:15;
    
%     figure
%     subplot(311), plot(f_psd,Sp);
%     subplot(312), plot(f_psd,cumtrapz(Sp));
%     subplot(313), plot(f_psd,cumtrapz(Sp)./repmat(trapz(Sp),size(Sp,1),1 ) );
    
    %FEATURESTEST
    F = size(inst,2);
    bins = 150;
    figure('units','normalized','position',[0.05 0.1 0.9 0.8]);
    selectedF = 1:F%[1 2 3 5 8 11 14 15 16];
    F = length(selectedF);
    
    LabelNames = {'Ambulation'; 'Cycling'; 'Others'; 'Sedentary'};
    for f = 1:F%F:-1:1
        indf = selectedF(f);
        
        
        M = max(inst(:,indf));
        h1 = subplot(4,F,f);
        f1 = hist(inst(labels==1,indf),0:M/bins:M);
        bar(0:M/bins:M, f1/sum(f1),1,'FaceColor','r');axis([0-M/bins M+M/bins 0 max(f1/sum(f1))])
        alpha(0.5), ylabel(['p(feature ' num2str(indf) ')'])
        legend(LabelNames{1})
        
        h2 = subplot(4,F,F+f);
        f2 = hist(inst(labels==2,indf),0:M/bins:M);
        bar(0:M/bins:M, f2/sum(f2),1,'FaceColor','b');axis([0-M/bins M+M/bins 0 max(f2/sum(f2))])
        alpha(0.5), ylabel(['p(feature ' num2str(indf) ')'])
        legend(LabelNames{2})
        
        h3 = subplot(4,F,2*F+f);
        f3 = hist(inst(labels==3,indf),0:M/bins:M);
        bar(0:M/bins:M, f3/sum(f3),1,'FaceColor','g');axis([0-M/bins M+M/bins 0 max(f3/sum(f3))])
        alpha(0.5), ylabel(['p(feature ' num2str(indf) ')'])
        legend(LabelNames{3})
        
        h4 = subplot(4,F,3*F+f);
        f4 = hist(inst(labels==4,indf),0:M/bins:M);
        bar(0:M/bins:M, f4/sum(f4),1,'FaceColor','c');axis([0-M/bins M+M/bins 0 max(f4/sum(f4))])
        %     h = findobj(gca,'Type','patch');
        %    set(h(1),'FaceColor','c')
        alpha(0.5), ylabel(['p(feature ' num2str(indf) ')'])
        legend(LabelNames{4})
        
        linkaxes([h1 h2 h3 h4],'x')
    end
    
end

%% 4: classification
disp('Classification:')

cm  = zeros(length(clasf),2,2);
cm4 = zeros(length(clasf),max(Lab2w),2);
cm5 = zeros(length(clasf),max(Lab2w),2);
cmg = zeros(length(clasf),max(Lab2w),2);
maxlabelnum = max(labels);

%% libSVM
sc_low = -1;
sc_up = 1;

kernel = 2;

Pb = 0;
termination = 0.0000001;

[N,F] = size(inst);
test_ind = 1:N;

if train_generalmodel
    Pb = 1;
    me = mean(inst);
    st = std(inst);
    for f = 1:F
        inst_sc(:,f) = (inst(:,f) - me(f)) ./ st(f);
    end
    model= svmtrain(labels, inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(bestc, '%12.12f') ' -g ' num2str(bestg, '%12.12f') ' -b ' num2str(Pb) ' -e ' num2str(termination, '%12.12f') ]);
    save([saveto '.mat'],'me', 'st', 'model' );
    
    return;
elseif use_generalmodel
    load([loadfrom '.mat'],'me', 'st', 'model')
    
    for f = 1:F
        inst_sc(:,f) = (inst(:,f) - me(f)) ./ st(f);
    end
    [predict, accuracy, prob] = svmpredict(labels, inst_sc, model, [' -b ' num2str(Pb)] );
    lab1 = unique(labels);
    lab2 = unique(predict);
    % confusion matrix
    [CM_aggr(lab1,lab2),ne,lablist] = confmat(labels, predict);
    test_generalmodels
    return;
else
    
    input.inst = inst;
    input.labels = labels;
    input.subj_label = subj_label;
    input.scalingtype = 2;
    input.sc_low = sc_low;
    input.sc_up = sc_up;
    input.kernel = 2;
    input.C = bestc;
    input.gamma = bestg;
    input.Pb = Pb;
    input.termination = termination;
    input.maxlabelnum = maxlabelnum;
   
    tic;
    fprintf(1, 'Starting LOSO validation:\n')
    output = l1o_valid_svm4_PAR(input);
    fprintf(1, 'End of LOSO validation: Elapsed time %f s\n', toc)
    
    CM_aggr = output.CM_aggr;
    CM = output.CM;
    Acc_aggr = output.Acc_aggr;
    Acc = output.Acc;
    predict = output.predict;
    model = output.model;
    prob = output.prob;
    predict_sorted = output.predict_sorted;
    prob_sorted = output.prob_sorted;
    
end
[SE,SP,PR,se,sp,pr,tp,fp,tn,fn] = confmat2SeSpPr(CM_aggr,0);

pred_i = predict_sorted;

%% 5: display output
figure('units','normalized','position',[0.1 0.1 0.8 0.8]);
subplot(311),imagesc(labels'), axis tight, title('Actual')
hold on
subplot(312),imagesc(pred_i'), axis tight , title('Classified')
subplot(313),imagesc(subj_label'), axis tight , title('Subject ID')
l1 = unique(labels);
l2 = unique(pred_i);
[CM3(l1,l2),ne3,lablist] = confmat(labels, pred_i);

acc = trace(CM3) / sum (sum(CM3));
disp('confusion matrix:')
CM_aggr
disp(['Accuracy: ' num2str(acc)])

for class = 1:maxlabelnum
    prec = pr(class);
    rec = se(class);
    F1_s(class) = 2/ (1/prec+1/rec);
    MCC(class) = (tp(class)*tn(class) - fp(class)*fn(class)) / sqrt( (tp(class)+fp(class))*(tp(class)+fn(class))*(tn(class)+fp(class))*(tn(class)+fn(class)));
end
disp(['F1 score:             ' num2str(F1_s)])
disp(['Mattews Corr. Coeff.: ' num2str(MCC)])

%% output
    lab2 = unique(pred_i);
lab3 = unique(labels);

score(1) = MCC(2);
cm(1,lab3,lab2) = CM_aggr;

CM_single{1} = CM;
Acc_aggr = sum(trace(CM_aggr)) /sum(sum(CM_aggr));


if (outputenabled)
    
    classif_name = {'svm'};
    class_name = {'walk','cycle','non-locomotion','rest'};
    
    figure('unit','normalized','position', [0.2 0.3 0.6 0.4]);
    subplot(121),imagesc(CM_aggr);
    somme = repmat(sum(CM_aggr,2),1,maxlabelnum);
    cm_perc = CM_aggr ./ somme;
    subplot(122),imagesc(cm_perc);colorbar; axis square
    cm_perc
    
    
    %% subclass labels
    others = (ismember(Lab1w,[3:11 15 18])) | (ismember(Lab2w,[2:6 11:12 17:21 75 76])) ;  %20130925
    
    lab1 = unique(Lab2w(~others)); lab2 = unique(pred_i(~others));
    [CM7(1:length(lab1),lab2) ,ne7,lablist7] = confmat(Lab2w(~others), pred_i(~others));
    lab1 = unique(Lab2w(others)); lab2 = unique(pred_i(others));
    [CM8(1:length(lab1),lab2) ,ne8,lablist8] = confmat(Lab2w(others), pred_i(others));
    
    availclass = unique(Lab2w(~others));
    availclass2 = unique(Lab2w(others));
    for aa = 1:length(availclass)
        availact_g{aa} = [ num2str(availclass(aa)) ': ' Info(1).activity_labels{availclass(aa)}  ];
    end
    for aa = 1:length(availclass2)
        availact_g2{aa} = [ num2str(availclass2(aa)) ': ' Info(1).activity_labels{availclass2(aa)}  ];
    end
    
    if aboutrun
        class1 = [1 22 23 25:36 45 65:73 77:83]; % walking
    else
        class1 = [1 22 23 25:36 45 65:73 79:81]; % walking
    end
    class2 = [7:10 43 44 47 48 ];            % cycling
    
    c1 = ismember( availclass, class1);
    c2 = ismember( availclass, class2);
    c3 = ~(c1|c2);
    
    f1 = figure('units','normalized','position',[0.1 0.1 0.8 0.8]);
    cnames = {'Walking', 'Cycling', 'Others', 'Resting'};
    t = uitable('Data',CM7(c1,:),'ColumnName',cnames,'RowName',availact_g(c1),'units','normalized','Position',[0.05 0.6 0.4 0.35]);
    t = uitable('Data',CM7(c2,:),'ColumnName',cnames,'RowName',availact_g(c2),'units','normalized','Position',[0.50 0.6 0.45 0.35]);
    t = uitable('Data',CM7(c3,:),'ColumnName',cnames,'RowName',availact_g(c3),'units','normalized','Position',[0.05 0.02 0.4 0.53]);
    t = uitable('Data',CM8,'ColumnName',cnames,'RowName',availact_g2,'units','normalized','Position',[0.50 0.20 0.45 0.35]);
    acc1 = sum(CM7(c1,1))/sum(sum(CM7(c1,:)));
    acc2 = sum(CM7(c2,2))/sum(sum(CM7(c2,:)));
    acc3 = sum(CM7(c3,3))/sum(sum(CM7(c3,:)));
    acc4 = sum(CM8(:,4))/sum(sum(CM8(:,:)));
    annotation(f1,'textbox',[0.05 0.9578 0.2236 0.02969],'String',{['Walking, accuracy = ' num2str(acc1)]},'FitBoxToText','off');
    annotation(f1,'textbox',[0.50 0.9566 0.2236 0.02969],'String',{['Cycling, accuracy = ' num2str(acc2)]},'FitBoxToText','off');
    annotation(f1,'textbox',[0.05 0.555 0.2236 0.02969],'String',{['Other activities, accuracy = ' num2str(acc3)]},'FitBoxToText','off');
    annotation(f1,'textbox',[0.50 0.555 0.2236 0.02969],'String',{['Resting, accuracy = ' num2str(acc4)]},'FitBoxToText','off');
    
    index3 = ismember (Lab2w, [38 37]);
    availpost = unique(Lab1w(index3));
    for aa = 1:length(availpost)
        availpost_g{aa} = [ num2str(availpost(aa)) ': ' Info(1).posture_labels{availpost(aa)}  ];
    end
    
    lab1 = unique(Lab1w(index3)); lab2 = unique(pred_i(index3));
    [CM9(1:length(lab1),lab2),ne9,lablist9] = confmat(Lab1w(index3), pred_i(index3));
    t = uitable('Data',CM9,'ColumnName',cnames,'RowName',availpost_g,'units','normalized','Position',[0.50 0.02 0.45 0.15]);
    
    
end


%% checks for Experiment 4
if kids_and_adults
    [CMY,neY,lablistY] = confmat(labels(subj_label<=NY), pred_i(subj_label<=NY))
    accY = trace(CMY) /sum(sum(CMY))
    [CMA,neA,lablistA] = confmat(labels(subj_label>NY), pred_i(subj_label>NY))
    accA = trace(CMA) /sum(sum(CMA))
end


